<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php';
header('Content-Type: application/json');

// Validasi metode
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

$connect = getDatabaseConnection();

// Ambil data POST
$id_pegawai   = $_POST['id_pegawai']   ?? null;
$nama_pegawai = $_POST['nama_pegawai'] ?? null;
$Tanggal      = $_POST['Tanggal']      ?? null;
$Nama_Klien   = $_POST['Nama_Klien']   ?? null;
$Time_in      = $_POST['Time_in']      ?? null;
$Keterangan   = $_POST['Keterangan']   ?? null;
$Alamat       = $_POST['Alamat']       ?? null;
$latlong      = $_POST['latlong']      ?? null;

// Normalisasi Tanggal ke format Y-m-d
if ($Tanggal) {
    $Tanggal = date('Y-m-d', strtotime($Tanggal));
}

// Validasi wajib isi
if (
    !$id_pegawai || !$nama_pegawai || !$Tanggal || !$Nama_Klien ||
    !$Time_in || !$Keterangan || !$Alamat || !$latlong ||
    !isset($_FILES['Foto']) || !isset($_FILES['Tandatangan'])
) {
    echo json_encode(['status' => 'error', 'message' => 'Semua field wajib diisi, termasuk foto dan tanda tangan']);
    exit;
}

// -------------------
// Fungsi bantu
// -------------------
function compressImage($source, $destination, $quality)
{
    $info = getimagesize($source);
    if (!$info) return false; // Tambahkan pengecekan validasi

    if ($info['mime'] === 'image/jpeg') {
        $image = imagecreatefromjpeg($source);
    } elseif ($info['mime'] === 'image/png') {
        $image = imagecreatefrompng($source);
        $background = imagecreatetruecolor(imagesx($image), imagesy($image));
        imagefill($background, 0, 0, imagecolorallocate($background, 255, 255, 255));
        imagealphablending($background, true);
        imagecopy($background, $image, 0, 0, 0, 0, imagesx($image), imagesy($image));
        $image = $background;
    } else {
        return false; // Format tidak didukung
    }

    return imagejpeg($image, $destination, $quality);
}
function normalizeString($str)
{
    return strtolower(trim(preg_replace('/\s+/', ' ', $str)));
}
function normalizeLatlong($str)
{
    return str_replace([' ', "\t", "\r", "\n"], '', trim($str));
}

// -------------------
// Cek Duplikat
// -------------------
$normalizedAlamat   = normalizeString($Alamat);
$normalizedLatlong  = normalizeLatlong($latlong);

$queryDup = $connect->prepare("
    SELECT 1 FROM t_kunjungan 
    WHERE id_pegawai = ? AND Tanggal = ?
    AND (
        REPLACE(latlong, ' ', '') = ?
        OR LOWER(TRIM(REPLACE(Alamat, '  ', ' '))) = ?
    )
    LIMIT 1
");
$queryDup->bind_param("isss", $id_pegawai, $Tanggal, $normalizedLatlong, $normalizedAlamat);
$queryDup->execute();
$queryDup->store_result();

if ($queryDup->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Sudah ada kunjungan dengan tempat yang sama di hari ini']);
    exit;
}
$queryDup->close();

// -------------------
// Upload Foto dan TTD
// -------------------
$upload_dir = '../../AppsMobile/VisitClient/foto/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

$foto_file = $_FILES['Foto'];
$foto_filename = "kunjungan_" . time() . ".jpg";
$foto_path = $upload_dir . $foto_filename;
if (!compressImage($foto_file['tmp_name'], $foto_path, 75)) {
    if (!move_uploaded_file($foto_file['tmp_name'], $foto_path)) {
        echo json_encode(['status' => 'error', 'message' => 'Gagal memproses atau mengunggah foto kunjungan']);
        exit;
    }
}

$tandatangan_file = $_FILES['Tandatangan'];
$tandatangan_filename = "ttd_" . time() . ".jpg";
$tandatangan_path = $upload_dir . $tandatangan_filename;
if (!compressImage($tandatangan_file['tmp_name'], $tandatangan_path, 75)) {
    if (!move_uploaded_file($tandatangan_file['tmp_name'], $tandatangan_path)) {
        echo json_encode(['status' => 'error', 'message' => 'Gagal memproses atau mengunggah foto tanda tangan']);
        exit;
    }
}

// -------------------
// Simpan ke DB
// -------------------
$foto_url = $foto_filename;
$tandatangan_url = $tandatangan_filename;

$query = "INSERT INTO t_kunjungan (id_pegawai, nama_pegawai, Tanggal, Nama_Klien, Time_in, Keterangan, Alamat, Foto, Tandatangan, latlong) 
          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt_insert = $connect->prepare($query);
$stmt_insert->bind_param("isssssssss", $id_pegawai, $nama_pegawai, $Tanggal, $Nama_Klien, $Time_in, $Keterangan, $Alamat, $foto_url, $tandatangan_url, $latlong);

if ($stmt_insert->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Data kunjungan berhasil ditambahkan',
        'data' => [
            'id_pegawai' => $id_pegawai,
            'nama_pegawai' => $nama_pegawai,
            'Tanggal' => $Tanggal,
            'Nama_Klien' => $Nama_Klien,
            'Time_in' => $Time_in,
            'Keterangan' => $Keterangan,
            'Alamat' => $Alamat,
            'Foto' => $foto_url,
            'Tandatangan' => $tandatangan_url,
            'latlong' => $latlong,
        ]
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Gagal menambahkan data kunjungan']);
}

$stmt_insert->close();
mysqli_close($connect);
