<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path menuju config file sesuai

header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter tanggal dari GET
$tanggal = $_GET['Tanggal'] ?? null;
$id_pegawai = $_GET['id_pegawai'] ?? null;

// Validasi parameter
if (!$tanggal || !$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'Tanggal dan ID Pegawai harus diisi']);
    exit;
}

// Query untuk total kunjungan pada tanggal tertentu
$query_total_visit = "SELECT COUNT(*) AS total_visit 
                      FROM t_kunjungan 
                      WHERE Tanggal = ? AND id_pegawai = ?";
$stmt_total = $connect->prepare($query_total_visit);
$stmt_total->bind_param("si", $tanggal, $id_pegawai);
$stmt_total->execute();
$result_total = $stmt_total->get_result();
$total_visit = $result_total->fetch_assoc()['total_visit'];

// Query untuk data keseluruhan kunjungan pada tanggal tertentu
$query_visit_details = "SELECT id_kunjungan, id_pegawai, nama_pegawai, Tanggal, Nama_Klien, Time_in, Keterangan, Alamat, Foto, Tandatangan, latlong 
                        FROM t_kunjungan 
                        WHERE Tanggal = ? AND id_pegawai = ?";
$stmt_details = $connect->prepare($query_visit_details);
$stmt_details->bind_param("si", $tanggal, $id_pegawai);
$stmt_details->execute();
$result_details = $stmt_details->get_result();

$visit_details = [];
while ($row = $result_details->fetch_assoc()) {
    $visit_details[] = $row;
}

// Query untuk data keseluruhan kunjungan sepanjang waktu
$query_overall_visits = "SELECT Tanggal, COUNT(*) AS total_visits 
                         FROM t_kunjungan 
                         WHERE id_pegawai = ? 
                         GROUP BY Tanggal 
                         ORDER BY Tanggal DESC";
$stmt_overall = $connect->prepare($query_overall_visits);
$stmt_overall->bind_param("i", $id_pegawai);
$stmt_overall->execute();
$result_overall = $stmt_overall->get_result();

$overall_visits = [];
while ($row = $result_overall->fetch_assoc()) {
    $overall_visits[] = $row;
}

// Response JSON
$response = [
    'status' => 'success',
    'message' => 'Riwayat kunjungan berhasil diambil',
    'data' => [
        'total_visit_on_date' => $total_visit,
        'visit_details_on_date' => $visit_details,
        'overall_visits' => $overall_visits,
    ]
];

echo json_encode($response);

// Tutup koneksi
$stmt_total->close();
$stmt_details->close();
$stmt_overall->close();
mysqli_close($connect);
?>