<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
$hostname   = "localhost";
$user       = "groupber_gaji";
$password   = "group_gaji24";
$database   = "groupber_payroll";

// Set header untuk menerima JSON
header('Content-Type: application/json');

// Tampilkan semua error untuk debug
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Koneksi ke database
$connect = mysqli_connect($hostname, $user, $password, $database);
if (!$connect) {
    error_log("Database connection failed: " . mysqli_connect_error());
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Baca data dari JSON
$data = json_decode(file_get_contents('php://input'), true);
error_log("Data diterima: " . print_r($data, true)); // Debug input data

// Validasi input
$id_penggajian = $data['id_penggajian'] ?? null;

if (!$id_penggajian) {
    error_log("Missing parameter: id_penggajian");
    echo json_encode(['status' => 'error', 'message' => 'Missing parameter: id_penggajian']);
    exit;
}


// Query update data
$stmt = $connect->prepare("
    UPDATE t_pembayaran_gaji 
    SET 
        jumlah_masuk = ?, 
        penerimaan_gaji = ?, 
        penerimaan_tunj_jabatan = ?, 
        penerimaan_tunj_transport = ?, 
        penerimaan_uang_makan = ?, 
        penerimaan_uang_makan_lembur = ?, 
        penerimaan_uang_makan_luar_kota = ?, 
        penerimaan_uang_pulsa = ?, 
        penerimaan_insentif_gudang = ?, 
        penerimaan_lembur = ?, 
        penerimaan_thr = ?, 
        penerimaan_lainnya = ?, 
        total_penerimaan = ?
    WHERE id_penggajian = ?
");

if (!$stmt) {
    error_log("Failed to prepare statement: " . mysqli_error($connect));
    echo json_encode(['status' => 'error', 'message' => 'Failed to prepare statement']);
    exit;
}

// Bind parameter
if (!$stmt->bind_param(
   'ddddddddddddds',
    $data['jumlah_masuk'],
    $data['penerimaan_gaji'],
    $data['penerimaan_tunj_jabatan'],
    $data['penerimaan_tunj_transport'],
    $data['penerimaan_uang_makan'],
    $data['penerimaan_uang_makan_lembur'],
    $data['penerimaan_uang_makan_luar_kota'],
    $data['penerimaan_uang_pulsa'],
    $data['penerimaan_insentif_gudang'],
    $data['penerimaan_lembur'],
    $data['penerimaan_thr'],
    $data['penerimaan_lainnya'],
    $data['total_penerimaan'],
    $id_penggajian // Ini juga string ('s')
)) {
    error_log("Failed to bind parameters: " . $stmt->error);
    echo json_encode(['status' => 'error', 'message' => 'Failed to bind parameters']);
    exit;
}

// Eksekusi query
if (!$stmt->execute()) {
    error_log("Error executing query: " . $stmt->error);
    echo json_encode(['status' => 'error', 'message' => 'Query execution failed']);
    exit;
}

// Berhasil
echo json_encode(['status' => 'success', 'message' => 'Data updated successfully']);
$stmt->close();
mysqli_close($connect);
?>