<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config_absen.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter tanggal dan id_pegawai
$Tanggal = isset($_GET['Tanggal']) ? $_GET['Tanggal'] : null;
$id_pegawai = isset($_GET['id_pegawai']) ? $_GET['id_pegawai'] : null;

if (!$Tanggal || !$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter Tanggal dan id_pegawai diperlukan',
    ]);
    exit;
}

$image_base_path = "https://groupberkat.com/AppsMobile/AmbilNota/foto/";

// Query untuk mengambil data berdasarkan tanggal dan id_pegawai
$query = "SELECT id_pegawai, NamaClient, Tanggal, NmrFaktur, FotoImg, Karyawan, Alamat 
          FROM KunjunganGudang 
          WHERE Tanggal = ? AND id_pegawai = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("ss", $Tanggal, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = [
        'id_pegawai' => $row['id_pegawai'],
        'NamaClient' => $row['NamaClient'],
        'Tanggal' => $row['Tanggal'],
        'NmrFaktur' => $row['NmrFaktur'],
        'FotoImg' => $row['FotoImg'] ? trim($image_base_path . $row['FotoImg']) : null,
        'Karyawan' => $row['Karyawan'],
        'Alamat' => $row['Alamat'],
    ];
}

// Jika data ditemukan
if (!empty($data)) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Data ditemukan',
        'data' => $data,
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Tidak ada data untuk kombinasi id_pegawai dan tanggal ini',
    ]);
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);

?>