<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
$hostname   = "localhost";
$user       = "groupber_gaji";
$password   = "group_gaji24";
$database   = "groupber_payroll";

// Set header untuk JSON
header('Content-Type: application/json');

// Koneksi ke database
$connect = mysqli_connect($hostname, $user, $password, $database);

// Cek koneksi database
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Ambil parameter dari GET
$id_penggajian = $_GET['id_penggajian'] ?? null;

// Validasi input
if (empty($id_penggajian)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing parameter: id_penggajian']);
    exit;
}

// Query database dengan prepared statement
$stmt = $connect->prepare("SELECT * FROM t_pembayaran_gaji WHERE id_penggajian = ?");
$stmt->bind_param("s", $id_penggajian);
$stmt->execute();
$result = $stmt->get_result();

// Cek apakah data ditemukan
if ($result->num_rows > 0) {
    $data = $result->fetch_assoc();

    // Hitung total penerimaan
    $total_penerimaan = $data['penerimaan_gaji'] +
                        $data['penerimaan_tunj_jabatan'] +
                        $data['penerimaan_tunj_transport'] +
                        $data['penerimaan_uang_makan'] +
                        $data['penerimaan_uang_makan_lembur'] +
                        $data['penerimaan_uang_makan_luar_kota'] +
                        $data['penerimaan_uang_pulsa'] +
                        $data['penerimaan_insentif_gudang'] +
                        $data['penerimaan_lembur'] +
                        $data['tunjangan_jht'] +
                        $data['tunjangan_jkk'] +
                        $data['tunjangan_jkm'] +
                        $data['penerimaan_thr'] +
                        $data['penerimaan_lainnya'] -
                        $data['potongan'];

    echo json_encode([
        'status' => 'success',
        'data' => [
            'id_penggajian' => $data['id_penggajian'],
            'id_pegawai' => $data['id_pegawai'],
            'jumlah_hari' => $data['jumlah_hari'],
            'penerimaan_gaji' => $data['penerimaan_gaji'],
            'penerimaan_tunj_jabatan' => $data['penerimaan_tunj_jabatan'],
            'penerimaan_tunj_transport' => $data['penerimaan_tunj_transport'],
            'penerimaan_uang_makan' => $data['penerimaan_uang_makan'],
            'penerimaan_uang_makan_lembur' => $data['penerimaan_uang_makan_lembur'],
            'penerimaan_uang_makan_luar_kota' => $data['penerimaan_uang_makan_luar_kota'],
            'penerimaan_uang_pulsa' => $data['penerimaan_uang_pulsa'],
            'penerimaan_insentif_gudang' => $data['penerimaan_insentif_gudang'],
            'penerimaan_lembur' => $data['penerimaan_lembur'],
            'tunjangan_jht' => $data['tunjangan_jht'],
            'tunjangan_jkk' => $data['tunjangan_jkk'],
            'tunjangan_jkm' => $data['tunjangan_jkm'],
            'penerimaan_lainnya' => $data['penerimaan_lainnya'],
            'potongan' => $data['potongan'],
            'status_gaji' => $data['status_gaji'],
            'penerimaan_thr' => $data['penerimaan_thr'],
            'total_penerimaan' => $total_penerimaan
        ]
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Data not found']);
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);
?>