<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
$hostname   = "localhost";
$user       = "groupber_gaji";
$password   = "group_gaji24";
$database   = "groupber_payroll";
// Set header untuk JSON
header('Content-Type: application/json');

// Koneksi ke database
$connect = mysqli_connect($hostname, $user, $password, $database);

// Cek koneksi database
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Ambil parameter dari POST
$tanggal_absensi = $_POST['tanggal_absensi'] ?? null;
$id_pegawai = $_POST['id_pegawai'] ?? null;

// Validasi input
if (empty($tanggal_absensi) || empty($id_pegawai)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing parameters']);
    exit;
}

// Query database dengan prepared statement
$stmt = $connect->prepare("SELECT * FROM t_absensi WHERE tanggal_absensi = ? AND id_pegawai = ?");
$stmt->bind_param("ss", $tanggal_absensi, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

// Cek apakah data ditemukan
if ($result->num_rows > 0) {
    $data = $result->fetch_assoc();
    echo json_encode([
        'status' => 'success',
        'data' => [
            'id_pegawai' => $data['id_pegawai'],
            'jam_masuk' => $data['jam_masuk'],
            'Masuk_Alamat' => $data['Masuk_Alamat'],
            'Masuk_Img' => $data['Masuk_Img'],
            'jam_keluar' => $data['jam_keluar'],
            'Pulang_Alamat' => $data['Pulang_Alamat'],
            'Pulang_Img' => $data['Pulang_Img'],
            'Masuk_LatLong' => $data['Masuk_LatLong'],
            'Pulang_LatLong' => $data['Pulang_LatLong']
        ]
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Data not found']);
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);
?>