<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config_absen.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter id_pegawai dan Tanggal
$id_pegawai = isset($_GET['id_pegawai']) ? $_GET['id_pegawai'] : null;
$Tanggal = isset($_GET['Tanggal']) ? $_GET['Tanggal'] : null;

if (!$id_pegawai || !$Tanggal) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter id_pegawai dan Tanggal diperlukan',
    ]);
    exit;
}

$image_base_path = "https://groupberkat.com/AppsMobile/Delivery/foto/";

// Query untuk mengambil data berdasarkan id_pegawai dan Tanggal
$query = "SELECT id_pegawai, NamaClient, Tanggal, NmrFaktur, FotoImg, Karyawan, Alamat 
          FROM Delivery 
          WHERE id_pegawai = ? AND Tanggal = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("ss", $id_pegawai, $Tanggal);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = [
        'id_pegawai' => $row['id_pegawai'],
        'NamaClient' => $row['NamaClient'],
        'Tanggal' => $row['Tanggal'],
        'NmrFaktur' => $row['NmrFaktur'],
        'FotoImg' => $row['FotoImg'] ? $image_base_path . $row['FotoImg'] : null,
        'Karyawan' => $row['Karyawan'],
        'Alamat' => $row['Alamat'],
    ];
}

// Jika data ditemukan
if (!empty($data)) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Data Delivery ditemukan',
        'data' => $data,
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Tidak ada data Delivery untuk id_pegawai dan tanggal tersebut',
    ]);
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);

?>