<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Naik dua level dari folder `api/auth/` ke `public_html`

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil data dari POST
$input = json_decode(file_get_contents('php://input'), true);

$telp_pegawai = $input['telp_pegawai'] ?? null;
$Pass_Login = $input['Pass_Login'] ?? null;

// Validasi input
if (!$telp_pegawai || !$Pass_Login) {
    http_response_code(400); // Bad Request
    echo json_encode(['status' => 'error', 'message' => 'Nomor telepon dan password wajib diisi']);
    exit;
}

// Query untuk mendapatkan data pegawai dan nama jabatan
$stmt = $connect->prepare("
    SELECT 
        p.id_pegawai,
        p.nama_pegawai,
        p.telp_pegawai,
        p.Pass_Login,
        j.nama_jabatan
    FROM t_pegawai AS p
    LEFT JOIN t_jabatan AS j ON p.id_jabatan = j.id_jabatan
    WHERE p.telp_pegawai = ?
");
$stmt->bind_param("s", $telp_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Jika nomor telepon terdaftar, cek password
    $pegawai = $result->fetch_assoc();

    if ($pegawai['Pass_Login'] === $Pass_Login) {
        http_response_code(200); // OK
        echo json_encode([
            'status' => 'success',
            'message' => 'Login berhasil',
            'data' => [
                'id_pegawai' => $pegawai['id_pegawai'],
                'nama_pegawai' => $pegawai['nama_pegawai'],
                'telp_pegawai' => $pegawai['telp_pegawai'],
                'nama_jabatan' => $pegawai['nama_jabatan'] ?? 'Tidak Ada Jabatan'
            ]
        ]);
    } else {
        http_response_code(401); // Unauthorized
        echo json_encode([
            'status' => 'error',
            'message' => 'Password salah'
        ]);
    }
} else {
    // Jika nomor telepon tidak terdaftar
    http_response_code(404); // Not Found
    echo json_encode([
        'status' => 'error',
        'message' => 'Nomor telepon tidak terdaftar'
    ]);
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);
?>