<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php';
header('Content-Type: application/json');

$connect = getDatabaseConnection();
$id_pegawai = $_GET['id_pegawai'] ?? null;
$tanggal = $_GET['tanggal'] ?? date('Y-m-d'); // Default ke hari ini jika tidak ada parameter tanggal

if (!$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'id_pegawai wajib diisi']);
    exit;
}

// Ambil data absensi untuk tanggal tertentu
$absenQuery = $connect->prepare("SELECT jam_masuk, jam_keluar, is_late FROM t_absensi WHERE id_pegawai = ? AND tanggal_absensi = ?");
$absenQuery->bind_param("ss", $id_pegawai, $tanggal);
$absenQuery->execute();
$resultAbsen = $absenQuery->get_result();

if ($resultAbsen->num_rows > 0) {
    $absenData = $resultAbsen->fetch_assoc();
    echo json_encode([
        'status' => 'success',
        'message' => 'Data absensi berhasil diambil',
        'data' => [
            'tanggal' => $tanggal,
            'id_pegawai' => $id_pegawai,
            'sudah_absen' => true,
            'jam_masuk' => $absenData['jam_masuk'] ?? null,
            'jam_keluar' => $absenData['jam_keluar'] ?? null,
            'telat' => $absenData['is_late'] == 1
        ]
    ]);
} else {
    echo json_encode([
        'status' => 'success',
        'message' => 'Pegawai belum absen pada tanggal ini',
        'data' => [
            'tanggal' => $tanggal,
            'id_pegawai' => $id_pegawai,
            'sudah_absen' => false,
            'jam_masuk' => null,
            'jam_keluar' => null,
            'telat' => false
        ]
    ]);
}

$absenQuery->close();
$connect->close();
