<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil data dari POST
$id_pegawai = $_POST['id_pegawai'] ?? null;
$tanggal_lembur = $_POST['tanggal_lembur'] ?? null;
$jam_masuk_lembur = $_POST['jam_masuk_lembur'] ?? null;
$kategori_lembur = $_POST['kategori_lembur'] ?? null;
$Masuk_Alamat = $_POST['Masuk_Alamat'] ?? null;

// Validasi input
if (!$id_pegawai || !$tanggal_lembur || !$jam_masuk_lembur || !$kategori_lembur || !$Masuk_Alamat) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Semua field wajib diisi',
        'received_input' => [
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
            'tanggal_lembur' => $tanggal_lembur ?? 'Tidak diterima',
            'jam_masuk_lembur' => $jam_masuk_lembur ?? 'Tidak diterima',
            'kategori_lembur' => $kategori_lembur ?? 'Tidak diterima',
            'Masuk_Alamat' => $Masuk_Alamat ?? 'Tidak diterima',
            'Masuk_Img' => isset($_FILES['Masuk_Img']) ? $_FILES['Masuk_Img']['name'] : 'Tidak diterima',
        ],
    ]);
    exit;
}

// Direktori untuk menyimpan gambar
$upload_dir = 'foto/lembur/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Proses upload gambar
$Masuk_Img = null;
if (isset($_FILES['Masuk_Img'])) {
    $file_name = time() . '_lembur.jpg';
    $file_path = $upload_dir . $file_name;

    if (move_uploaded_file($_FILES['Masuk_Img']['tmp_name'], $file_path)) {
        $Masuk_Img = $file_name; // Simpan nama file ke database
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal mengunggah gambar']);
        exit;
    }
}

// Cek apakah data lembur sudah ada
$query_check = "SELECT * FROM t_lembur WHERE id_pegawai = ? AND tanggal_lembur = ?";
$stmt_check = $connect->prepare($query_check);
$stmt_check->bind_param("is", $id_pegawai, $tanggal_lembur);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Data lembur Anda hari ini sudah ada']);
} else {
    // Insert data lembur baru
    $query_insert = "INSERT INTO t_lembur (id_pegawai, tanggal_lembur, jam_masuk_lembur, kategori_lembur, Masuk_Img, Masuk_Alamat) 
                     VALUES (?, ?, ?, ?, ?, ?)";
    $stmt_insert = $connect->prepare($query_insert);
    $stmt_insert->bind_param("isssss", $id_pegawai, $tanggal_lembur, $jam_masuk_lembur, $kategori_lembur, $Masuk_Img, $Masuk_Alamat);

    if ($stmt_insert->execute()) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Data lembur telah diterima',
            'data' => [
                'tanggal_lembur' => $tanggal_lembur,
                'jam_masuk_lembur' => $jam_masuk_lembur,
                'kategori_lembur' => $kategori_lembur,
                'Masuk_Alamat' => $Masuk_Alamat,
                'Masuk_Img' => $Masuk_Img,
            ],
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal menambahkan data lembur']);
    }

    $stmt_insert->close();
}

// Tutup koneksi
$stmt_check->close();
mysqli_close($connect);
?>