<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path menuju file konfigurasi database
header('Content-Type: application/json');

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter dari URL
$tanggal_lembur = $_GET['tanggal_lembur'] ?? null;
$id_pegawai = $_GET['id_pegawai'] ?? null;

// Validasi input
if (!$tanggal_lembur || !$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter tanggal_lembur dan id_pegawai wajib diisi',
        'received_input' => [
            'tanggal_lembur' => $tanggal_lembur ?? 'Tidak diterima',
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Query untuk memeriksa data lembur
$query = "SELECT * FROM t_lembur WHERE tanggal_lembur = ? AND id_pegawai = ?";
$stmt = $connect->prepare($query);
$stmt->bind_param("si", $tanggal_lembur, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

// Periksa hasil query
if ($result->num_rows > 0) {
    $data = $result->fetch_assoc();

    echo json_encode([
        'status' => 'success',
        'message' => 'Data lembur ditemukan',
        'data' => [
            'tanggal_lembur' => $data['tanggal_lembur'],
            'id_pegawai' => $data['id_pegawai'],
            'jam_masuk_lembur' => $data['jam_masuk_lembur'] ?? null, // Jika kolom tersedia
            'jam_keluar_lembur' => $data['jam_keluar_lembur'] ?? null, // Jika kolom tersedia
            'kategori_lembur' => $data['kategori_lembur'] ?? null, // Jika kolom tersedia
            'Masuk_Alamat' => $data['Masuk_Alamat'] ?? null, // Jika kolom tersedia
            'Masuk_Img' => $data['Masuk_Img'] ?? null, // Jika kolom tersedia
            'hari' => $data['hari'] ?? null, // Jika kolom tersedia
            'Pulang_Alamat' => $data['Pulang_Alamat'] ?? null, // Jika kolom tersedia
            'Pulang_Img' => $data['Pulang_Img'] ?? null, // Jika kolom tersedia
        ],
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Data lembur tidak ditemukan',
    ]);
}

// Tutup koneksi
$stmt->close();
$connect->close();

?>