<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
require '../../config.php'; // Pastikan path menuju file konfigurasi database
header('Content-Type: application/json');

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter dari URL
$id_pegawai = $_GET['id_pegawai'] ?? null;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1; // Default halaman 1
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10; // Default 10 item per halaman

// Validasi input
if (!$id_pegawai) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter id_pegawai wajib diisi',
        'received_input' => [
            'id_pegawai' => $id_pegawai ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

if ($page < 1 || $limit < 1) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Parameter page dan limit harus lebih besar dari 0',
    ]);
    exit;
}

// Hitung offset untuk pagination
$offset = ($page - 1) * $limit;

// Query untuk mengambil riwayat lembur dengan pagination
$query_history = "SELECT * FROM t_lembur WHERE id_pegawai = ? ORDER BY tanggal_lembur DESC LIMIT ? OFFSET ?";
$stmt_history = $connect->prepare($query_history);
$stmt_history->bind_param("iii", $id_pegawai, $limit, $offset);
$stmt_history->execute();
$result_history = $stmt_history->get_result();

$history = [];
while ($row = $result_history->fetch_assoc()) {
    $history[] = [
        'tanggal_lembur' => $row['tanggal_lembur'],
        'jam_masuk_lembur' => $row['jam_masuk_lembur'] ?? null,
        'jam_keluar_lembur' => $row['jam_keluar_lembur'] ?? null,
        'kategori_lembur' => $row['kategori_lembur'] ?? null,
        'hari' => $row['hari'] ?? null,
        'Pulang_Alamat' => $row['Pulang_Alamat'] ?? null,
        'Masuk_Alamat' => $row['Masuk_Alamat'] ?? null,
        'Masuk_Img' => $row['Masuk_Img'] ?? null,
        'Pulang_Img' => $row['Pulang_Img'] ?? null,
    ];
}

// Hitung total data untuk menghitung jumlah halaman
$query_count = "SELECT COUNT(*) AS total FROM t_lembur WHERE id_pegawai = ?";
$stmt_count = $connect->prepare($query_count);
$stmt_count->bind_param("i", $id_pegawai);
$stmt_count->execute();
$result_count = $stmt_count->get_result();
$total_data = $result_count->fetch_assoc()['total'];

// Hitung total halaman
$total_pages = ceil($total_data / $limit);

// Respons API
if (!empty($history)) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Riwayat lembur ditemukan',
        'data' => $history,
        'pagination' => [
            'current_page' => $page,
            'per_page' => $limit,
            'total_pages' => $total_pages,
            'total_data' => $total_data,
        ],
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Riwayat lembur tidak ditemukan untuk pegawai ini',
        'pagination' => [
            'current_page' => $page,
            'per_page' => $limit,
            'total_pages' => $total_pages,
            'total_data' => $total_data,
        ],
    ]);
}

// Tutup koneksi
$stmt_history->close();
$stmt_count->close();
$connect->close();

?>