<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php';
header('Content-Type: application/json');

// Validasi metode HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil parameter dari URL
$id_pegawai = $_GET['id_pegawai'] ?? null;
$bulan = $_GET['bulan'] ?? null;   // optional
$tahun = $_GET['tahun'] ?? null;   // optional

if (!$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'Parameter id_pegawai wajib diisi']);
    exit;
}

$query = "
    SELECT 
        j.tanggal,
        t.jam_mulai,
        t.jam_selesai,
        t.nama_shift,
        t.warna,
        t.role
    FROM t_shift_jadwal j
    JOIN t_shift_tipe t ON j.id_shift_tipe = t.id_shift_tipe
    WHERE j.id_pegawai = ?
";

// Tambahkan filter jika bulan dan tahun tersedia
if ($bulan && $tahun) {
    $query .= " AND MONTH(j.tanggal) = ? AND YEAR(j.tanggal) = ?";
    $query .= " ORDER BY j.tanggal ASC";
    $stmt = $connect->prepare($query);
    $stmt->bind_param("sii", $id_pegawai, $bulan, $tahun);
} else {
    $query .= " ORDER BY j.tanggal DESC";
    $stmt = $connect->prepare($query);
    $stmt->bind_param("s", $id_pegawai);
}

$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $shift_list = [];
    while ($row = $result->fetch_assoc()) {
        $shift_list[] = [
            'tanggal' => $row['tanggal'],
            'jam_mulai' => $row['jam_mulai'],
            'jam_selesai' => $row['jam_selesai'],
            'nama_shift' => $row['nama_shift'],
            'warna' => $row['warna'],
            'role' => $row['role']
        ];
    }

    echo json_encode([
        'status' => 'success',
        'message' => 'Data shift ditemukan',
        'data' => $shift_list
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Tidak ada data shift ditemukan untuk bulan ini'
    ]);
}

$stmt->close();
$connect->close();
