<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php';
header('Content-Type: application/json');

$connect = getDatabaseConnection();

$id_pegawai = $_GET['id_pegawai'] ?? null;
$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

if (!$id_pegawai) {
    echo json_encode(['status' => 'error', 'message' => 'id_pegawai wajib diisi']);
    exit;
}

$tanggalAwal = "$tahun-$bulan-01";
$tanggalAkhir = date("Y-m-t", strtotime($tanggalAwal));
$tanggalHariIni = date('Y-m-d');

// Ambil data absensi
$queryAbsen = $connect->prepare("SELECT tanggal_absensi, jam_masuk, jam_keluar FROM t_absensi WHERE id_pegawai = ? AND tanggal_absensi BETWEEN ? AND ?");
$queryAbsen->bind_param("sss", $id_pegawai, $tanggalAwal, $tanggalAkhir);
$queryAbsen->execute();
$resultAbsen = $queryAbsen->get_result();
$absenMap = [];

while ($a = $resultAbsen->fetch_assoc()) {
    $absenMap[$a['tanggal_absensi']] = [
        'jam_masuk' => $a['jam_masuk'],
        'jam_keluar' => $a['jam_keluar']
    ];
}

// Ambil hari libur
$queryLibur = $connect->prepare("SELECT tgl_libur FROM groupber_payroll.t_hari_libur WHERE tgl_libur BETWEEN ? AND ?");
$queryLibur->bind_param("ss", $tanggalAwal, $tanggalAkhir);
$queryLibur->execute();
$resultLibur = $queryLibur->get_result();
$liburList = [];
while ($row = $resultLibur->fetch_assoc()) {
    $liburList[] = $row['tgl_libur'];
}

// Ambil shift (walau hari libur)
$queryShift = $connect->prepare("SELECT tanggal FROM t_shift_jadwal WHERE id_pegawai = ? AND tanggal BETWEEN ? AND ?");
$queryShift->bind_param("sss", $id_pegawai, $tanggalAwal, $tanggalAkhir);
$queryShift->execute();
$resultShift = $queryShift->get_result();
$shiftList = [];
while ($s = $resultShift->fetch_assoc()) {
    $shiftList[] = $s['tanggal'];
}

// Cek hari kerja
$periode = new DatePeriod(
    new DateTime($tanggalAwal),
    new DateInterval('P1D'),
    (new DateTime($tanggalAkhir))->modify('+1 day')
);

$alfaList = [];

foreach ($periode as $date) {
    $tanggal = $date->format('Y-m-d');
    $hariKe = (int)$date->format('N');
    $isWeekend = $hariKe >= 7;
    $isLibur = in_array($tanggal, $liburList);
    $adaShift = in_array($tanggal, $shiftList);
    $hitungHariKerja = (!$isWeekend && !$isLibur) || $adaShift;

    if ($hitungHariKerja && $tanggal < $tanggalHariIni && !isset($absenMap[$tanggal])) {
        // Tidak ada absen sama sekali
        $alfaList[] = [
            'tanggal' => $tanggal,
            'jam_masuk' => null,
            'jam_keluar' => null
        ];
    }

    if ($hitungHariKerja && $tanggal < $tanggalHariIni && isset($absenMap[$tanggal])) {
        $jamMasuk = $absenMap[$tanggal]['jam_masuk'];
        $jamKeluar = $absenMap[$tanggal]['jam_keluar'];
        if (empty($jamMasuk) || empty($jamKeluar)) {
            $alfaList[] = [
                'tanggal' => $tanggal,
                'jam_masuk' => $jamMasuk,
                'jam_keluar' => $jamKeluar
            ];
        }
    }
}

echo json_encode([
    'status' => 'success',
    'message' => 'Daftar hari tidak hadir (alfa)',
    'data' => $alfaList
]);
