<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require '../../config.php'; // Pastikan path menuju config file sesuai
header('Content-Type: application/json');

// Periksa apakah metode HTTP adalah POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Koneksi ke database
$connect = getDatabaseConnection();

// Ambil data dari JSON
$input = json_decode(file_get_contents('php://input'), true);

// Ambil data dari JSON atau beri nilai default null
$eid = $input['eid'] ?? null;
$ename = $input['ename'] ?? null;
$descr = $input['descr'] ?? null;
$fromdate = $input['fromdate'] ?? null;
$todate = $input['todate'] ?? null;

// Validasi input
if (!$eid || !$ename || !$descr || !$fromdate || !$todate) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Semua field wajib diisi',
        'received_input' => [
            'eid' => $eid ?? 'Tidak diterima',
            'ename' => $ename ?? 'Tidak diterima',
            'descr' => $descr ?? 'Tidak diterima',
            'fromdate' => $fromdate ?? 'Tidak diterima',
            'todate' => $todate ?? 'Tidak diterima',
        ],
    ]);
    exit;
}

// Periksa apakah pengajuan izin sudah ada
$query_check = "SELECT * FROM t_perizinan WHERE ename = ? AND fromdate = ?";
$stmt_check = $connect->prepare($query_check);
$stmt_check->bind_param("ss", $ename, $fromdate);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Data izin sudah ada']);
} else {
    // Masukkan data izin dengan status default 'Pending'
    $status = 'Pending';
    $query_insert = "INSERT INTO t_perizinan (eid, ename, descr, fromdate, todate, status) 
                     VALUES (?, ?, ?, ?, ?, ?)";
    $stmt_insert = $connect->prepare($query_insert);
    $stmt_insert->bind_param("ssssss", $eid, $ename, $descr, $fromdate, $todate, $status);

    if ($stmt_insert->execute()) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Izin berhasil dikirim',
            'data' => [
                'eid' => $eid,
                'ename' => $ename,
                'descr' => $descr,
                'fromdate' => $fromdate,
                'todate' => $todate,
                'status' => $status,
            ],
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal mengirim izin']);
    }

    $stmt_insert->close();
}

// Tutup koneksi
$stmt_check->close();
mysqli_close($connect);
