<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
$hostname   = "localhost";
$user       = "groupber_gaji";
$password   = "group_gaji24";
$database   = "groupber_payroll";
header('Content-Type: application/json');

// Koneksi ke database
$connect = mysqli_connect($hostname, $user, $password, $database);

// Cek koneksi
if (!$connect) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed']);
    exit;
}

// Ambil data dari POST
$tanggal_absensi = $_POST['tanggal_absensi'] ?? null;
$id_pegawai = $_POST['id_pegawai'] ?? null;
$Masuk_LatLong = $_POST['Masuk_LatLong'] ?? null;
$Masuk_Img = $_POST['Masuk_Img'] ?? null;
$Masuk_Alamat = $_POST['Masuk_Alamat'] ?? null;
$status_kehadiran = $_POST['status_kehadiran'] ?? null;
$keterangan_absensi = $_POST['keterangan_absensi'] ?? null;
$jam_masuk = $_POST['jam_masuk'] ?? null; // Tambahkan jam_masuk

// Validasi input
if (!$tanggal_absensi || !$id_pegawai  || !$status_kehadiran || !$keterangan_absensi || !$jam_masuk) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

// Cek apakah data sudah ada
$stmt = $connect->prepare("SELECT * FROM t_absensi WHERE tanggal_absensi = ? AND id_pegawai = ?");
$stmt->bind_param("ss", $tanggal_absensi, $id_pegawai);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Data already exists']);
} else {
    // Insert data baru
    $stmt = $connect->prepare("INSERT INTO t_absensi (tanggal_absensi, id_pegawai, Masuk_LatLong, Masuk_Img, Masuk_Alamat, status_kehadiran, keterangan_absensi, jam_masuk) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssss", $tanggal_absensi, $id_pegawai, $Masuk_LatLong, $Masuk_Img, $Masuk_Alamat, $status_kehadiran, $keterangan_absensi, $jam_masuk);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Data inserted successfully']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to insert data']);
    }
}

// Tutup koneksi
$stmt->close();
mysqli_close($connect);
?>